Sub Main()

    setupParams = {}

    setupParams.setupEthernet = true

    setupParams.ethernetParams = {}

    setupParams.ethernetParams.useDHCP = <<REPLACEUSEDHCP>>
    ' example : setupParams.ethernetParams.useDHCP = true

    setupParams.ethernetParams.staticIPAddress = <<REPLACESTATICIPADDRESS>>
    ' example : setupParams.ethernetParams.staticIPAddress = "192.168.2.15"
    setupParams.ethernetParams.subnetMask = <<REPLACESUBNETMASK>>
    ' example : setupParams.ethernetParams.subnetMask = "255.255.255.0"
    setupParams.ethernetParams.gateway = <<REPLACEGATEWAY>>
    ' example : setupParams.ethernetParams.gateway = "192.168.2.1"
    setupParams.ethernetParams.dns1 = <<REPLACEDNS1>>
    ' example : setupParams.ethernetParams.dns1 = "192.168.2.1"
    setupParams.ethernetParams.dns2 = <<REPLACEDNS2>>
    ' example : setupParams.ethernetParams.dns2 = "10.1.0.35"
    setupParams.ethernetParams.dns3 = <<REPLACEDNS3>>
    ' example : setupParams.ethernetParams.dns3 = ""

    setupParams.ethernetParams.timeServer = <<REPLACETIMESERVER>>
    ' example : setupParams.ethernetParams.timeServer = "http://time.brightsignnetwork.com"
    setupParams.ethernetParams.proxySpec = <<REPLACEPROXYSPEC>>
    ' example : setupParams.ethernetParams.proxySpec = ""
    setupParams.ethernetParams.bypassProxyHosts = []

    setupParams.setupWireless = false

    setupParams.wirelessParams = {}

    ' enter SSID, passphrase below
    setupParams.wirelessParams.ssid = ""
    setupParams.wirelessParams.passphrase = ""

    setupParams.wirelessParams.useDHCP = true

    setupParams.wirelessParams.timeServer = <<REPLACETIMESERVER>>
    ' example : setupParams.wirelessParams.timeServer = "http://time.brightsignnetwork.com"
    setupParams.wirelessParams.proxySpec = <<REPLACEPROXYSPEC>>
    ' example : setupParams.wirelessParams.proxySpec = ""
    setupParams.wirelessParams.bypassProxyHosts = []

    timeZone = <<REPLACETIMEZONE>>

    if timeZone <> "" then
        ncz = CreateObject("roSystemTime")
        ncz.SetTimeZone(timeZone)
    endif

    <<REPLACECUSTOMSCRIPT>>
    setupNetwork(setupParams)

End Sub



Sub setupNetwork(setupParams As Object)

    if type(setupParams.setupEthernet) = "roBoolean" and setupParams.setupEthernet and type(setupParams.ethernetParams) = "roAssociativeArray" then
        nc = CreateObject("roNetworkConfiguration", 0)
        if type(nc) = "roNetworkConfiguration" then
            ConfigureNetwork(nc, setupParams.ethernetParams)
        endif
    endif

    if type(setupParams.setupWireless) = "roBoolean" and setupParams.setupWireless and type(setupParams.wirelessParams) = "roAssociativeArray" then
        nc = CreateObject("roNetworkConfiguration", 1)
        if type(nc) = "roNetworkConfiguration" then
            ConfigureNetwork(nc, setupParams.wirelessParams)
        endif
    else
        DisableWireless()
    endif

End Sub


Sub ConfigureNetwork(nc As Object, networkingParameters As Object)

    if type(networkingParameters.ssid) = "roString" then
        nc.SetWiFiESSID(networkingParameters.ssid)
        nc.SetWiFiPassphrase(networkingParameters.passphrase)
    endif

    if networkingParameters.useDHCP then
        nc.SetDHCP()
    else
		nc.SetIP4Address(networkingParameters.staticIPAddress)
		nc.SetIP4Netmask(networkingParameters.subnetMask)
		nc.SetIP4Gateway(networkingParameters.gateway)
		if networkingParameters.dns1 <> "" then nc.AddDNSServer(networkingParameters.dns1)
		if networkingParameters.dns2 <> "" then nc.AddDNSServer(networkingParameters.dns2)
		if networkingParameters.dns3 <> "" then nc.AddDNSServer(networkingParameters.dns3)
    endif

    nc.SetRoutingMetric(-1)

	nc.SetTimeServer(networkingParameters.timeServer)
	nc.SetProxy(networkingParameters.proxySpec)
    nc.SetProxyBypass(networkingParameters.bypassProxyHosts)
	nc.SetInboundShaperRate(-1)

	ok = nc.Apply()

End Sub


Sub DisableWireless()
	nc = CreateObject("roNetworkConfiguration", 1)
	if type(nc) = "roNetworkConfiguration" then
		nc.SetDHCP()
		nc.SetWiFiESSID("")
		nc.SetObfuscatedWifiPassphrase("")
		nc.Apply()
	endif
End Sub