' name file autorun.zip
' Content update application
Sub Main()
    tempFolder$ = GetTempPath()
    source$ = FindSourcePath()

    if IsExists(tempFolder$) then
        DeleteDirectory(tempFolder$)
    end if

    CreateDirectory(tempFolder$)

    package = CreateObject("roBrightPackage", source$ + "autorun.zip")
    package.SetPassword("test")
    package.Unpack(tempFolder$)
    package = 0

    appspacePath$ = GetAppspacePath()
    scriptsFolder$ = "/scripts/"
    utilsFile$ = "utils.brs"
    utilsSourcePath$ = tempFolder$ + "appspace" + scriptsFolder$ + utilsFile$
    scriptsSourceFolderPath$ = tempFolder$ + "appspace" + scriptsFolder$
    scriptsTargetFolderPath$ = appspacePath$ + scriptsFolder$
    utilsTargetPath$ = appspacePath$ + scriptsFolder$ + utilsFile$

    ' unpack just appspace package
    Run([utilsSourcePath$, scriptsSourceFolderPath$ + "setup-package.brs"])
    ' unpack main scripts (autorun.brs & plugins.brs) using the extracted scripts
    Run([utilsTargetPath$, scriptsTargetFolderPath$ + "setup-main-scripts.brs"])
    ' unpack plugins package
    Run([utilsTargetPath$, scriptsTargetFolderPath$ + "setup-plugins-package.brs"])
    ' clean up using the extracted scripts
    Run([utilsTargetPath$, scriptsTargetFolderPath$ + "clean-up.brs"])

    ' reboot system
    a=RebootSystem()
End Sub

Function FindDestPath()
    if not IsFirmwareValid() then
        return "SD:/"
    end if

    destinationPaths = ["SSD:", "SD:", "USB1:"]
    for each destination in destinationPaths
        if IsMounted(destination) then
            return destination+"/"
        end if
    next
    return "unknown"
End Function

Function FindSourcePath()
    if not IsFirmwareValid() then
        return "SD:/"
    end if

    sourcePaths = ["USB1:", "SD:", "SSD:"]
    for each source in sourcePaths
        if IsMounted(source) and IsExists(source+"/autorun.zip") then
            return source+"/"
        end if
    next
    return "unknown"
End Function

Function GetTempPath()
    return FindDestPath() + "appspacetemp/"
End Function

Function GetAppspacePath()
    return FindDestPath() + "appspace"
End Function

Function IsFirmwareValid()
    di = CreateObject("roDeviceInfo")
    return di.FirmwareIsAtLeast("7.0.60")
End Function

Function IsMounted(path as String)
    if CreateObject("roStorageHotplug").GetStorageStatus(path).mounted then
        return true
    end if

    return false
End Function

Function IsExists(path as String)
    file = CreateObject("roReadFile", path)
    if type(file) = "roReadFile" then
        return true
    end if

    return false
End Function