Function ReadJsonFile(path as String)    
    return ParseJson(ReadAsciiFile(path))
End Function

Function WriteJsonFile(path as String, data as Object) As Void
    WriteAsciiFile(path, FormatJson(data))
End Function

Function FindDestPath()
    if not IsFirmwareValid() then
        return "SD:/"
    end if

    destinationPaths = ["SSD:", "SD:", "USB1:"]
    for each destination in destinationPaths
        if IsMounted(destination) then
            return destination+"/"
        end if
    next
    return "unknown"
End Function

Function FindSourcePath()
    if not IsFirmwareValid() then
        return "SD:/"
    end if

    sourcePaths = ["USB1:", "SD:", "SSD:"]
    for each source in sourcePaths
        if IsMounted(source) and IsExists(source+"/autorun.zip") then
            return source+"/"
        end if
    next
    return "unknown"
End Function

Function IsMounted(path as String)
    if CreateObject("roStorageHotplug").GetStorageStatus(path).mounted then
        return true
    end if

    return false
End Function

Function IsFirmwareValid()
    di = CreateObject("roDeviceInfo")
    return di.FirmwareIsAtLeast("7.0.60")
End Function

Function IsExists(path as String)
    file = CreateObject("roReadFile", path)
    if type(file) = "roReadFile" then
        return true
    end if

    return false
End Function

Function ConvertSEM(value) 
    if type(value) <> "roString" and type(value) <> "String" then return 0
    
    sum = 0
    arr = value.Tokenize(".")

    if arr[0] <> invalid then
        sum = sum + arr[0].toInt() * 1000000000
    end if

    if arr[1] <> invalid then
        sum = sum + arr[1].toInt() * 1000000
    end if    

    if arr[2] <> invalid then
        ' break down unstandard sem 
        ' 0-ci10
        regex = CreateObject("roRegex", "[0-9]+", "i")
        buildString = arr[2].Tokenize("-")
        major = buildString[0].toInt() * 1000
        minor = 0

        if buildString[1] <> invalid then
            minor = (regex.Match(buildString[1])[0]).toInt()
        end if
        sum = sum + major + minor
    end if       

    return sum     
End Function

Function GetTempPath()
    return FindDestPath() + "appspacetemp/"
End Function

Function GetAppspacePath()
    return FindDestPath() + "appspace"
End Function

Function JoinPath(path1 as String, path2 as String)
    return path1 + "/" + path2
End Function