Sub Main()
    tempFolder$ = GetTempPath()
    rootPath$= FindDestPath()

    pluginsFolderName$ = "plugins"
    pluginsTargetPath$ = rootPath$ + pluginsFolderName$
    pluginsSourcePath$ = tempFolder$ + pluginsFolderName$

    if IsExists(pluginsSourcePath$) then
        ' if /plugins is not there, create first
        if IsExists(pluginsTargetPath$) = false then
            CreateDirectory(pluginsTargetPath$)
        end if

        pluginsSource = ListDir(pluginsSourcePath$)
        for each pluginName in pluginsSource
            pluginTargetPath$ = JoinPath(pluginsTargetPath$, pluginName)
            pluginSourcePath$ = JoinPath(pluginsSourcePath$, pluginName)
            ' if the same plugin exists, delete first
            if IsExists(pluginTargetPath$) then
                DeleteDirectory(pluginTargetPath$)
            end if

            MoveFile(pluginSourcePath$, pluginTargetPath$)
        end for
    end if

    ' no clean up as it will be manual process
    ' this is to support updating through a generic autorun.zip without deleting the existing plugins folder
End Sub