Sub Main()
    tempFolder$ = GetTempPath()
    rootPath$ = FindDestPath()
    appspaceNewPath$ = GetAppspacePath()

    appspaceWwwFolder$ = tempFolder$ + "www"
    appspaceConfigFolder$ = tempFolder$ + "scripts"
    appspaceSourcePath$ = tempFolder$ + "appspace"
    policyFile$ = "policy.json"
    configFile$ = "config-init.brs"
    mainFolder$ = "main"
    scriptsFolder$ = "scripts"
    mainFile$ = "main.brs"
    appspacePolicyPath$ = appspaceWwwFolder$ + "/" + policyFile$
    appspacePolicyNewPath$ = appspaceNewPath$ + "/" + policyFile$
    appspaceConfigPath$ = appspaceConfigFolder$ + "/" + configFile$
    appspaceConfigNewPath$ = appspaceNewPath$ + "/scripts/" + configFile$
    appspaceMainPath$ = tempFolder$ + "appspace/" + mainFolder$
    appspaceMainNewPath$ = appspaceNewPath$ + "/" + mainFolder$
    appspaceScriptPath$ = appspaceSourcePath$ + "/scripts"
    appspaceScriptNewPath$ = appspaceNewPath$ + "/scripts"

    ' if /appspace folder doesn't exists, create
    if IsExists(appspaceNewPath$) = false then
        CreateDirectory(appspaceNewPath$)
    end if

    ' /appspace/main folder doesn't exists, copy the whole appspace directory        
    if IsExists(appspaceMainNewPath$) = false then
        MoveFile(appspaceSourcePath$, appspaceNewPath$)        
    else ' if /appspace/main folder exists, we need to perform upgrade
        appspaceMainNewPath$ = appspaceNewPath$ + "/" + GetNewMainFolder(appspaceMainPath$ + "/")
        ' move /temp/appspace/main folder to /appspace/<target>
        MoveFile(appspaceMainPath$, appspaceMainNewPath$)
        ' move /temp/appspace/scripts to /appspace/scripts
        if IsExists(appspaceScriptNewPath$) then
            DeleteDirectory(appspaceScriptNewPath$)
        end if
        MoveFile(appspaceScriptPath$, appspaceScriptNewPath$)
        ' copy main.brs
        MoveFile(appspaceSourcePath$ + "/main.brs", appspaceNewPath$ + "/main.brs")
        ' update _config.json
        ' for the new path, use / instead of sd:/ or sdd:/
        newHtmlPath = appspaceMainNewPath$.Mid(rootPath$.Len() - 1)
        UpdateConfig(newHtmlPath, appspaceNewPath$ + "/")
    end if

    ' copy examples folder
    MoveFile(tempFolder$ + "examples", rootPath$ + "examples")

    ' if the package comes with policy.json generated by Appspace, move it to the appspace folder
    if IsExists(appspacePolicyPath$) then
        MoveFile(appspacePolicyPath$, appspacePolicyNewPath$)
    end if

    ' if the package comes with scripts/config-init.brs file, move it to appspace folder
    if IsExists(appspaceConfigPath$) then
        MoveFile(appspaceConfigPath$, appspaceConfigNewPath$)
    end if

    CleanupBackwardCompatibleFiles(appspaceNewPath$)
    ' clean up old packages
    CleanupAppDirectories(appspaceNewPath$)
End Sub

Function GetNewMainFolder(path as String)
    versionFile = path + "_version.json"
    newFolder = "main"
    if IsExists(versionFile) = false then
        return newFolder
    end if
    
    versionData = ReadJsonFile(versionFile)
    if versionData <> invalid and versionData.DoesExist("buildVersion") and versionData.buildVersion <> "" then
        newFolder = "app-" + versionData.buildVersion
    end if

    return newFolder
End Function

Function UpdateConfig(newPath as String, path as String) As Void
    configFile = path + "_config.json"
    if IsExists(configFile) = false then
        return
    end if
    
    configFileData = ReadJsonFile(configFile)
    if configFileData = invalid
        configFileData = CreateObject("roAssociativeArray")
    end if

    configFileData.AddReplace("startupUrl", newPath + "/index.html")
    WriteJsonFile(configFile, configFileData)
End Function

Sub CleanupBackwardCompatibleFiles(path as String)
    ' delete file in /appspace/autorun.brs
    DeleteDirectory(path + "/autorun.brs")
    ' delete /appspace/www
    DeleteDirectory(path + "/www")
End Sub

' maintain 2 recent (based on the semantic versioning) folders
Sub CleanupAppDirectories(path as String)
    prefix = "app-"
    directoriesToKeep = 2
    directories = ListDir(path)
    appDirectories = CreateObject("roArray", 0, true)
    for each directoryName in directories
        if directoryName.Instr(prefix) >= 0 then
            appDirectories.Push(directoryName.Mid(prefix.Len()))            
        end if
    end for

    ' sort the folders
    directoryLength = appDirectories.count()-1
    for i=0 to directoryLength step 1
        for j=i+1 to directoryLength step 1
            if ConvertSEM(appDirectories[i]) < ConvertSEM(appDirectories[j]) then
                swap = appDirectories[i]
                appDirectories[i] = appDirectories[j]
                appDirectories[j] = swap
            end if
        end for
    end for

    ' remove directories that is above the limit
    for i = 0 to directoryLength step 1
        if i >= directoriesToKeep then
            DeleteDirectory(path + "/" + prefix + appDirectories[i])    
        end if
    end for
End Sub