Sub Main()
    tmpPath = "/tmp"
    directories = ListDir(tmpPath)
    lastZipEpoch = 0
    ' get the latest zip file inside /tmp
    for each directoryName in directories
        if directoryName.Instr(".zip") > 0 then
            epochTime = directoryName.Mid(0, directoryName.Len() - 4).toInt()
            if epochTime > lastZipEpoch then
                lastZipEpoch = epochTime
            end if
        end if
    end for

    lastZipFile = tmpPath + "/" + lastZipEpoch.ToStr() + ".zip"
    Debug("Checking " + lastZipFile)
    ' if the zip file exists, copy to root folder
    if IsExists(lastZipFile) then
        Debug("Copying " + lastZipFile + " to root")
        if CopyFile(lastZipFile, "/autorun.zip") then
            Debug("Successfully copied " + lastZipFile + " to root")
        end if
    end if

    ' clean up tmp folder and pre-plugin folder structures
    Debug("Cleaning up")
    DeleteDirectory(tmpPath)
    DeleteDirectory("/appspace")
    DeleteDirectory("/scripts")
    DeleteDirectory("/www")
    DeleteDirectory("/_config.json")
    DeleteDirectory("/active-version.json")
    DeleteDirectory("/deployment.json")
    DeleteDirectory("/autorun.brs")
End Sub

Sub Debug(message as string)
    slog = createobject("roSystemLog")
    slog.sendline("APPSPACE|post-upgrade.brs: " + message)
End Sub

Function IsExists(path as String)
    file = CreateObject("roReadFile", path)
    if type(file) = "roReadFile" then
        return true
    end if

    return false
End Function