Sub Main(packageRootPath$ as string, rootPath$ as string)
    LogMessage("Running main")
    packageRootPath$ = CleanFolderPath(packageRootPath$)
    rootPath$ = CleanFolderPath(rootPath$)
    if IsExists(packageRootPath$) = false then
        LogMessage("packageRootPath$ doesn't exist: " + packageRootPath$)
        stop
    end if

    if IsExists(rootPath$) = false then
        LogMessage("rootPath$ doesn't exist: " + rootPath$)
        stop
    end if

    appspacePath$ = rootPath$ + "appspace"
    scriptsFolder$ = "/scripts/"
    utilsFile$ = "utils.brs"
    utilsSourcePath$ = packageRootPath$ + "appspace" + scriptsFolder$ + utilsFile$
    scriptsSourceFolderPath$ = packageRootPath$ + "appspace" + scriptsFolder$
    setupPackagePath$ = scriptsSourceFolderPath$ + "setup-package.brs"
    LogMessage("Running " + setupPackagePath$)
    ' unpack just appspace package
    Run([utilsSourcePath$, setupPackagePath$])
End Sub

Function CleanFolderPath(path as string)
    if right(path, 1) <> "/" then
        path = path + "/"
    end if

    return path
End Function

Function IsExists(path as String)
    file = CreateObject("roReadFile", path)
    if type(file) = "roReadFile" then
        return true
    end if

    return false
End Function

Sub LogMessage(message as string)
    slog = createobject("roSystemLog")
    slog.sendline("APPSPACE|install-appspace-plugin.brs: " + message)
End Sub