Library "/appspace/scripts/upgrade.brs"

Function appspace_Initialize(messagePort As Object, userVariables As Object, bsp As Object)
    return NewAppspacePlugin(messagePort, userVariables)
End Function

Function NewAppspacePlugin(messagePort As Object, userVariables As Object)
    appspacePlayUrlFolder$ = "file:/appspace/main/"
    policyFileName$ = "policy.json"
    virtualKeyboardFile$ = "assets/brightsign/bsvirtualkb.html"
    webSocketFile$ = "wss/node-server.html"    
    policyUrl$ = "/appspace/" + policyFileName$
    targetPolicyUrl$ = "/appspace/main/" + policyFileName$
    webSocketServerUrl$ = appspacePlayUrlFolder$ + webSocketFile$
    configUrl$ = "/appspace/scripts/config-init.brs"
    displayRotation = 0
    cursorVisible = false

    EnableZoneSupport(1)

    ' global
    m.appspaceGlobal = CreateObject("roAssociativeArray")
    m.appspaceGlobal.appspacePlayUrl$ = appspacePlayUrlFolder$ + "index.html"
    m.appspaceGlobal.virtualKeyboardUrl$ = appspacePlayUrlFolder$ + virtualKeyboardFile$
    m.appspaceGlobal.messagePort = messagePort
    m.appspaceGlobal.isReady = false
    m.appspaceGlobal.updating = false
    m.appspaceGlobal.configFile = "/appspace/_config.json"
    m.appspaceGlobal.config = CreateObject("roAssociativeArray")
    m.appspaceGlobal.downloadQueue = CreateObject("roAssociativeArray")
    m.appspaceGlobal.downloadKeys = CreateObject("roAssociativeArray")
    m.appspaceGlobal.isReadyQueue = CreateObject("roArray", 0, true)
    m.appspaceGlobal.isWebSocketStart = false
    
    'intialize audio output with initial value of 50
    m.appspaceGlobal.audioHDMIOutput = CreateObject("roAudioOutput", "HDMI")
    m.appspaceGlobal.audioAnalogOutput = CreateObject("roAudioOutput", "Analog")

    ' display resolution
    vm=CreateObject("roVideoMode")

    m.appspaceGlobal.width=vm.GetResX()
    m.appspaceGlobal.height=vm.GetResY()

    m.appspaceGlobal.touchScreen = CreateObject("roTouchScreen")

    ' Debug Server
    registrySection = CreateObject("roRegistrySection", "networking")
    registrySection.write("http_server", "8080")

    ' telnet
    registrySection.delete("telnet")
    registrySection.write("ssh","22")

    registrySection.flush()

    registryHtmlSection = CreateObject("roRegistrySection", "html")
    registryHtmlSection.write("enable-inspector-server", "1")
    registryHtmlSection.write("disable-web-security", "1")
    registryHtmlSection.flush()

    ' startup scripts
    if CheckFile(configUrl$) then
        run(configUrl$)
        PrintRunError(LINE_NUM)
        MoveFile(configUrl$, configUrl$ + ".executed")
    end if

    ' set startup url
    if CheckFile(m.appspaceGlobal.configFile) then
        m.appspaceGlobal.config = LoadConfig()

        if m.appspaceGlobal.config <> invalid then
            ' set startup url
            if m.appspaceGlobal.config.startupUrl <> invalid and CheckFile(m.appspaceGlobal.config.startupUrl) then
                m.appspaceGlobal.appspacePlayUrl$ = m.appspaceGlobal.config.startupUrl
                ' if appspaceUrl is /appspace/1.50.2-build64/index.html, returns /appspace/1.50.2-build64/
                appspacePlayUrlFolder$ = m.appspaceGlobal.appspacePlayUrl$.Mid(0, m.appspaceGlobal.appspacePlayUrl$.Len() - 10)
                ' append wss/node-server.html to the retrieved string
                webSocketServerUrl$ = appspacePlayUrlFolder$ + webSocketFile$
                m.appspaceGlobal.virtualKeyboardUrl$ = appspacePlayUrlFolder$ + virtualKeyboardFile$
                ' combine /appspace/1.50.2-build64/ with policy.json
                targetPolicyUrl$ = appspacePlayUrlFolder$ + policyFileName$
            else
                ' handling app deleted
                SetStartupUrl(m.appspaceGlobal.appspacePlayUrl$)
            end if

            ' set display rotation
            if m.appspaceGlobal.config.displayRotation <> invalid then
                m.displayRotation = m.appspaceGlobal.config.displayRotation
            end if

            if m.appspaceGlobal.config.cursorVisible <> invalid then
                m.cursorVisible = m.appspaceGlobal.config.cursorVisible
            end if
        end if
    else
        ' default startup url
        SetStartupUrl(m.appspaceGlobal.appspacePlayUrl$)
    end if

    if IsFirmware8() then
        ' start web socket server
        CreateWebSocketHtmlWidget(webSocketServerUrl$)
        audioRouting = {
            mode: "prerouted"
        }
        audioConfiguration = CreateObject("roAudioConfiguration")
        audioConfiguration.ConfigureAudio(audioRouting)
    end if

    ' cursor appearance
    m.appspaceGlobal.touchScreen.EnableCursor(cursorVisible)

    ' copy main policy file to active appspace folder
    if CheckFile(policyUrl$) then
        CopyFile(policyUrl$, targetPolicyUrl$)
    end if

    ' Start of program
    m.appspaceGlobal.htmlWidget = CreateHtmlWidget(m.appspaceGlobal.appspacePlayUrl$, messagePort)
    m.appspaceGlobal.htmlWidgetShown = false
    m.appspaceGlobal.htmlWidget.Show()
    m.appspaceGlobal.htmlWidgetShown = true
    SetDisplayRotation(m.appspaceGlobal.htmlWidget, displayRotation)

    ' vKeyboard
    m.appspaceGlobal.vKeyboardProp = {isVKeyboardEnabled:false, isVKeyboardShow:false}

    ' start web server udp listener
    PrintMessage("Starting roDatagramReceiver")
    m.appspaceGlobal.receiver = CreateObject("roDatagramReceiver", 55537)
    m.appspaceGlobal.receiver.SetPort(m.appspaceGlobal.messagePort)

    return {
        appspaceGlobal: m.appspaceGlobal,
        msgPort: messagePort,
        objectName: "AppspacePlugin",
        userVariables: userVariables
        ProcessEvent: appspaceProcessEvent
    }
End Function

Function appspaceProcessEvent(event As Object)
    if type(m.appspaceGlobal.inAppBrowserMessagePort) = "roMessagePort" then
        inAppBrowserEvent = m.appspaceGlobal.inAppBrowserMessagePort.getMessage()
        if type(inAppBrowserEvent) = "roHtmlWidgetEvent"
            PrintMessage("in-app browser: firing widget html load event")
            inAppBrowserEventData = inAppBrowserEvent.GetData()
            FireHTMLWidgetLoadEvent(inAppBrowserEventData.reason)
        end if
    end if

    if type(event) = "roUrlEvent" then
        ' completed
        if event.GetInt() = 1
            ' Lookup object
            responseCode = event.GetResponseCode()
            downloadId = event.GetSourceIdentity()
            transfer = m.appspaceGlobal.downloadQueue.Lookup(downloadId.ToStr())

            if responseCode = 200 then
                if transfer.value.IsEmpty() <> true then
                    if transfer.value.callback = "UpgradePackage" then
                        UpgradePackage(transfer.value.options)
                    else if transfer.value.callback = "UpgradeFirmware" then
                        UpgradeFirmware(transfer.value.options)
                    else
                        m.appspaceGlobal.htmlWidget.PostJSMessage({
                            id: transfer.key,
                            message: "Invalid function",
                            result: false
                        })
                    end if
                else
                    m.appspaceGlobal.htmlWidget.PostJSMessage({
                        id: transfer.key,
                        result: true
                    })
                end if
            else
                ' error -10001 is cancelled
                ' error -10002
                if transfer <> invalid then
                    m.appspaceGlobal.htmlWidget.PostJSMessage({
                        id: transfer.key,
                        errorCode: responseCode,
                        message: event.GetFailureReason()
                        result: false
                    })

                    ' cancel transfer
                    if transfer.Lookup("value") <> invalid then
                        if transfer.value.callback = "UpgradePackage" then
                            CancelUpdatePackage()
                        else if transfer.value.callback = "UpgradeFirmware" then
                            CancelUpdateFirmware()
                        end if
                    end if
                end if
            end if

            if transfer <> invalid then
                ' Remove from queue
                m.appspaceGlobal.downloadQueue.delete(downloadId.ToStr())
                m.appspaceGlobal.downloadKeys.delete(transfer.key)
            end if
        end if

    end if

    if type(event) = "roHtmlWidgetEvent" then
        evData = event.GetData()
        if evData.reason = "load-started" then
            Reset()
        else if evData.reason = "load-finished" then
            m.appspaceGlobal.isReady = true

            key = m.appspaceGlobal.isReadyQueue.Pop()
            while key <> invalid
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: key,
                    result: true
                })
                key = m.appspaceGlobal.isReadyQueue.Pop()
            end while
            ResetReadyQueue()
        else if evData.reason = "message" then
            commandId = evData.message.id
            evCommand = evData.message.command

            if evCommand = "getIpAddress" then
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    result: true,
                    id: commandId,
                    address: GetIpAddress()
                })
            else if evCommand = "getMacAddress" then
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    result: true,
                    id: commandId,
                    mac: GetMacAddress()
                })
            else if evCommand = "getAvailableStorage" then
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id:commandId,
                    result: true,
                    available:GetAvailableStorage()
                })
            else if evCommand = "getUsedStorage" then
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id:commandId,
                    result: true,
                    used:GetUsedStorage()
                })
            else if evCommand = "createDirectory" then
                path$ = evData.message.path

                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id:commandId,
                    result: createDirectory(path$)
                })
            else if evCommand = "checkDirectory" then
                path$ = evData.message.path

                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id:commandId,
                    result: CheckDirectory(path$)
                })
            else if evCommand = "removeDirectory" then
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id:commandId,
                    result:DeleteDirectory(evData.message.path)
                })
            else if evCommand = "enumerateDirectory" then
                dirs = ListDir(evData.message.path)

                ' parsing files
                i = 0
                files$ = ""
                for each key in dirs
                    if i = dirs.Count()-1 then
                        files$ = files$ + key
                    else
                        files$ = files$ + key + ","
                    end if
                    i = i + 1
                end for

                ' return results
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id:commandId,
                    files: files$,
                    result:true
                })
            else if evCommand = "createFile" then
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id:commandId,
                    result:WriteAsciiFile(evData.message.path, "")
                })
            else if evCommand = "checkFile" then
                path$ = evData.message.path

                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id:commandId,
                    result: CheckFile(path$)
                })
            else if evCommand = "writeFile" then
                path$ = evData.message.path
                content$ = evData.message.content

                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id:commandId,
                    result:WriteAsciiFile(path$, content$)
                })
            else if evCommand = "moveFile" then
                sourcePath$ = evData.message.sourcePath
                destinationPath$ = evData.message.destinationPath

                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id:commandId,
                    result:MoveFile(sourcePath$, destinationPath$)
                })
            else if evCommand = "removeFile" then
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id:commandId,
                    result:DeleteFile(evData.message.path)
                })
            else if evCommand = "downloadUrl" then
                res = evData.message
                DownloadUrl(res.id, res.remotePath, res.localPath, {}, res.headers)
            else if evCommand = "updatePackage" then
                url$ = evData.message.url
                reboot$ = evData.message.reboot

                ' start updating in background
                UpdatePackage(commandId, url$, reboot$)
            else if evCommand = "updateFirmware" then
                url$ = evData.message.url
                ' start updating in background
                UpdateFirmware(commandId, url$)
            else if evCommand = "init" then
                if m.appspaceGlobal.isReady = false then
                    m.appspaceGlobal.isReadyQueue.Push(commandId)
                else
                    ' return directly
                    m.appspaceGlobal.htmlWidget.PostJSMessage({
                        id: commandId,
                        result: true
                    })
                end if
            else if evCommand = "setStartupUrl" then
                startupUrl$ = evData.message.url
                SetStartupUrl(startupUrl$)

                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: commandId,
                    result: true
                })
            else if evCommand = "setDisplayRotation" then
                rotation = evData.message.rotation

                if rotation <> invalid then
                    result = SetDisplayRotation(m.appspaceGlobal.htmlWidget, rotation.ToInt())
                    SetKeyboardDisplayRotation()
                    SetInAppBrowserDisplayRotation()
                    m.appspaceGlobal.htmlWidget.PostJSMessage({
                        id: commandId,
                        result: result
                    })
                end if
            else if evCommand = "getDisplayRotation" then
                rotation = GetDisplayRotation()

                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: commandId,
                    rotation: rotation
                    result: true
                })
            else if evCommand = "reboot" then
                RebootSystem()
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: commandId,
                    result: true
                })
            else if evCommand = "reload" then
                m.appspaceGlobal.htmlWidget.SetUrl(m.appspaceGlobal.appspacePlayUrl$)
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: commandId,
                    result: true
                })
            else if evCommand = "executeScript" then
                script$ = evData.message.script
                result = ExecuteScript(script$)

                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: commandId,
                    result: result
                })
            else if evCommand = "executeFile" then
                path$ = evData.message.path
                result = ExecuteFile(path$)

                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: commandId,
                    result: result
                })
            else if evCommand = "setCursorVisible" then
                visible = evData.message.visible
                SetCursorVisible(visible)

                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: commandId,
                    result: true
                })
            else if evCommand = "getCursorVisible" then
                result = GetCursorVisible()
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: commandId,
                    visible: result
                    result: true
                })
            else if evCommand = "getDisplayResolution" then
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    result: true,
                    id: commandId,
                    x: GetDisplayResolutionX(),
                    y: GetDisplayResolutionY()
                })
            else if evCommand = "getMemoryUsage" then
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    result: true,
                    id: commandId,
                    memory: GetMemoryUsage()
                })
            else if evCommand = "getCpuUsage" then
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    result: true,
                    id: commandId,
                    cpu: GetCpuUsage()
                })
            else if evCommand = "startServer" then
                port$ = evData.message.port
                startServer(port$)
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: "udpservermessage_" + commandId,
                    message: "serverstart",
                    result: true
                })
            else if evCommand = "stopServer" then
                stopServer()
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: "udpservermessage_" + commandId,
                    message: "serverstop",
                    result: true
                })
            else if evCommand = "createVirtualKeyboard" then
                result = false
                ' to avoid vkeyboard created more than one
                if m.appspaceGlobal.vKeyboardProp.isVKeyboardEnabled=false then
                    result = true
                    createVKeyboard(m.appspaceGlobal.virtualKeyboardUrl$)
                end if
                
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: commandId,
                    message: "createVKeyboardDone",
                    result: result
                })
            else if evCommand = "removeVirtualKeyboard" then
                removeVKeyboard()
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: commandId,
                    message: "removeVKeyboardDone",
                    result: true
                })
            else if evCommand = "setVolume" then
                volume = evData.message.volume
                setVolume(volume)
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: commandId,
                    message: "setVolume",
                    result: true,
                    volume: volume
                })
            else if evCommand = "createInAppBrowser" then
                url = evData.message.url
                createInAppBrowser(url)
            else if evCommand = "disposeInAppBrowser" then
                disposeInAppBrowser()
            else if evCommand = "clearWebCache" then
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: commandId,
                    message: "clearWebCache",
                    result: clearWebCache()
                })
            else 
                ' reject uknown command
                m.appspaceGlobal.htmlWidget.PostJSMessage({
                    id: commandId,
                    result: false,
                    message: "Invalid brightsign command."
                })
            end if
        end if

    end if

    if type(event) = "roDatagramEvent" then
        PrintMessage("Received event roDatagramEvent")
        if m.appspaceGlobal.isWebSocketStart = true then
            print "roDatagramEvent : "; event
            m.appspaceGlobal.htmlWidget.PostJSMessage({
                id: "udpservermessage_",
                result: true,
                message: event
            })
        end if

    end if

    if type(event) = "roVirtualKeyboardEvent" then

        if event.GetData().reason = "show-event"
            m.appspaceGlobal.vKeyboard.show()
            m.appspaceGlobal.vKeyboardProp.isVKeyboardShow = true 
        end if
        if event.GetData().reason = "hide-event"
            m.appspaceGlobal.vKeyboard.hide()
            m.appspaceGlobal.vKeyboardProp.isVKeyboardShow = false 
        end if

    end if
    'return false if another plugin or event processor should get a chance to handle this event
    return false
End Function
'''''''''''''''''''''''''''
Sub FireHTMLWidgetLoadEvent(event as String)
    if event.Instr("load-") = -1 then
        return
    end if
    
    m.appspaceGlobal.htmlWidget.PostJSMessage({
        id: "html_widget_event",
        message: event,
        url: m.appspaceGlobal.inAppBrowserUrl
    })
End Sub
'''''''''''''''''''''''''''
Sub PrintRunError(ln)
    'http://docs.brightsign.biz/display/BSV61/6.1-Built-In+Functions#id-6.1-Built-InFunctions-GetLastRunRuntimeError()
	systemLog = CreateObject("roSystemLog")
	el = GetLastRunCompileError()	
	if el = invalid then
		el = GetLastRunRuntimeError()
		if el = &hFC or el = &hE2 then return  
			'FC==ERR_NORMAL_END, E2=ERR_VALUE_RETURN
			print "Runtime Error (line ";ln;"): ";el
			if type(el) = "Integer" then
				value$ = str(el)
			else	
				value$ = "Unexpected type"
			end if	
			systemLog.sendline("  @@@ WARNING!!! @@@ ")
			systemLog.sendline("  @@@ BrightScript DWS LOG Debug Info - Runtime error in file Run() at line " + str(ln) + "  @@@ ")
			systemLog.sendline("  @@@ Error description in config-init.brs file can be identified 4 lines up  @@@ ")
			systemLog.sendline("  @@@ WARNING!!! @@@ ")
			systemLog.sendline("")
		else
			print "  compile error (line ";ln;") "
			systemLog.sendline("  @@@ WARNING!!! @@@ ")
			systemLog.sendline("  @@@ BrightScript DWS LOG Debug Info - Compile error in file Run() at line " + str(ln) + "  @@@ ")

			for each e in el
				for each i in e
					if type(e[i]) = "Integer" then
						value$ = str(e[i])
					else if type(e[i]) = "roString" then 
						value$ = e[i]
					else if type(e[i]) = "String" then
						value$ = e[i]
					else 
						value$ = "Unexpected type"
					end if 
					systemLog.sendline( "  @@@ BrightScript DWS LOG Debug Info " + i + "  :  " + value$ + "   @@@ ")
				end for
				
			end for
			
			systemLog.sendline("  @@@ WARNING!!! @@@ ")
			systemLog.sendline("")
		'stop
    end if
End Sub
'''''''''''''''''''''''''''
Function ResetReadyQueue()
    m.appspaceGlobal.isReady = false
    m.appspaceGlobal.isReadyQueue.Clear()
End Function
'''''''''''''''''''''''''''
Function Reset()
    PrintMessage("Resetting..")

    for each key in m.appspaceGlobal.downloadQueue
        download = m.appspaceGlobal.downloadQueue.Lookup(key)
        download.urlTransfer.AsyncCancel()
        PrintMessage("Cancelled download: " + download.urlTransfer.GetUrl())
    end for
End Function
'''''''''''''''''''''''''''
Function ShowMessage(msg as String, time as Integer)
    rect=CreateObject("roRectangle", 0, 0, m.appspaceGlobal.width, m.appspaceGlobal.height)
    textWidget = CreateObject("roTextWidget", rect, 1, 2, 1)
    r = CreateObject("roRectangle", 30, 30, m.appspaceGlobal.width - 30, 60)
    textWidget.SetSafeTextRegion(r)
    textWidget.PushString(msg)
    textWidget.Show()
    sleep(time)

End Function
'''''''''''''''''''''''''''
Function CreateWebSocketHtmlWidget(url as String)
    rect = CreateObject("roRectangle", 0, 0, 0, 0)
    config = {
    	nodejs_enabled: true
    	brightsign_js_objects_enabled: true
        url: url
	}
    webSocketServerWidget = CreateObject("roHtmlWidget", rect, config)
    webSocketServerWidget.Show()
    m.appspaceGlobal.htmlWidgetWebSocketServer = webSocketServerWidget
End Function
'''''''''''''''''''''''''''
Function DestroyWebSocketHtmlWidget()
    m.appspaceGlobal.htmlWidgetWebSocketServer.Hide()
    m.appspaceGlobal.htmlWidgetWebSocketServer = invalid
End Function
'''''''''''''''''''''''''''
Function CreateHtmlWidgetLegacy(config as Object, defaultPath as String, rect as Object)
    htmlWidget = CreateObject("roHtmlWidget", rect)
    htmlWidget.SetHWZDefault("on")
    htmlWidget.EnableSecurity(config.security_params.websecurity)
    htmlWidget.EnableJavascript(config.javascript_enabled)
    htmlWidget.EnableMouseEvents(config.mouse_enabled)
    htmlWidget.StartInspectorServer(config.inspector_server.port)
    htmlWidget.SetLocalStorageDir(config.storage_path)
    htmlWidget.SetAppCacheDir(defaultPath+"appcache")
    ' indexdb, default to 100mb storage
    htmlWidget.SetWebDatabaseDir(defaultPath+"webdb")
    htmlWidget.SetWebDatabaseQuota(104857600)
    return htmlWidget

End Function
'''''''''''''''''''''''''''
Function CreateHtmlWidget(url as String, messagePort as Object)
    defaultPath= GetDefaultDrive()
    rect=CreateObject("roRectangle", 0, 0, m.appspaceGlobal.width, m.appspaceGlobal.height)
    config = {
        hwz_default: "off",
        security_params: { websecurity: false}
        javascript_enabled: true,
        mouse_enabled: true,
        inspector_server: { port: 2999 },
        storage_path: defaultPath + "localdb",
        storage_quota: "2000000000",
        brightsign_js_objects_enabled: true,
        port: messagePort,
        url: url
    }
    ' BS documentation on FirmwareIsAtLeast is wrong
    ' the method will return true if device firmware is equal or bigger
    if IsFirmware8() <> true then
        htmlWidget = CreateHtmlWidgetLegacy(config, defaultPath, rect)
        htmlWidget.SetUrl(config.url)
        htmlWidget.SetPort(config.port)
    else
        htmlWidget = CreateObject("roHtmlWidget", rect, config)
    end if
    jsClasses = CreateObject("roAssociativeArray")
    jsClasses["all"] = [ "*" ]
    jsClasses["*"] = [ "*" ]
    htmlWidget.AllowJavaScriptURLs(jsClasses)
    return htmlWidget
End Function
Function IsFirmware8()
    deviceInfo = CreateObject("roDeviceInfo")
    return deviceInfo.FirmwareIsAtLeast("8.0.0")
End Function
'''''''''''''''''''''''''''
Function GetIpAddress()
    ipAddress$ = GetIpAddressByInterface(0)
    ' If we are unable to get IP address from Ethernet (0)
    ' then get the IP address from WiFi (1)
    if ipAddress$ = invalid or ipAddress$ = "" then
        ipAddress$ = GetIpAddressByInterface(1)
    end if
    return ipAddress$
End Function
'''''''''''''''''''''''''''
Function GetIpAddressByInterface(interface as Integer)
    networkConf = CreateObject("roNetworkConfiguration", interface)
    if networkConf = invalid or networkConf.GetCurrentConfig() = invalid then
        return ""
    end if
    return networkConf.GetCurrentConfig().ip4_address
End Function
'''''''''''''''''''''''''''
Function GetMacAddress()
    ' Get network configuration from Ethernet (0)
    networkConf = CreateObject("roNetworkConfiguration", 0)
    return networkConf.GetCurrentConfig().ethernet_mac
End Function
'''''''''''''''''''''''''''
Function GetAvailableStorage()
    ' returns in mebibytes
    si=CreateObject("roStorageInfo", GetDefaultDrive())
    return si.GetFreeInMegabytes()
End Function
'''''''''''''''''''''''''''
Function GetUsedStorage()
    ' returns in mebibytes
    si=CreateObject("roStorageInfo", GetDefaultDrive())
    return si.GetUsedInMegabytes()
End Function
'''''''''''''''''''''''''''
Function CheckDirectory(path as String)
    ' try read directory
    if right(path, 1) <> "/" then
        path = path + "/"
    end if
    dir = CreateObject("roReadFile", path)

    ' check is directory
    if type(dir) = "roReadFile" then
        return true
    end if

    return false
End Function
'''''''''''''''''''''''''''
Function CheckFile(path as String)
    ' try read file, remove trailing slash
    if right(path, 1) = "/" then
        path = left(path, path.Len()-1)
    end if
    file = CreateObject("roReadFile", path)

    ' try read directory, add trailing slash
    dirPath = path
    if right(dirPath, 1) <> "/" then
        dirPath = dirPath + "/"
    end if
    dir = CreateObject("roReadFile", dirPath)

    ' check is file is exist, while directory not returning
    if type(file) = "roReadFile" and dir = invalid then
        return true
    end if

    return false
End Function
'''''''''''''''''''''''''''
Function DownloadUrl(key as String, url as String, path as String, value, headers=invalid)
    urlTransfer = CreateObject("roUrlTransfer")
    urlTransfer.setPort(m.appspaceGlobal.messagePort)
    urlTransfer.SetUrl(url)
    downloadLogMessage = "Downloading " + url
    headersLogMessage = ""
    if headers <> invalid then
        parsedHeaders = ParseJson(headers)
        if parsedHeaders <> invalid and parsedHeaders.isEmpty() = false then
            for each header in parsedHeaders
                urlTransfer.AddHeader(header, parsedHeaders[header])
            end for
            headersLogMessage = " with headers: " + headers
        end if
    end if
    PrintMessage(downloadLogMessage + headersLogMessage)
    downloadId = urlTransfer.GetIdentity()
    result = urlTransfer.AsyncGetToFile(path)

    ' custom callback object
    transfer = {
        key: key
        urlTransfer: urlTransfer,
        value: value
    }

    ' add to download queue
    m.appspaceGlobal.downloadQueue.AddReplace(downloadId.ToStr(), transfer)

    ' map user downloadId to sytem downloadId
    m.appspaceGlobal.downloadKeys.AddReplace(key, downloadId)
End Function
'''''''''''''''''''''''''''
Function LoadConfig()
    return ParseJson(ReadAsciiFile(m.appspaceGlobal.configFile))
End Function
Function SaveConfig(key as String, value)
    config = LoadConfig()

    if config = invalid then
        config = CreateObject("roAssociativeArray")
    end if
    config.AddReplace(key, value)
    WriteAsciiFile(m.appspaceGlobal.configFile, FormatJson(config))
End Function
'''''''''''''''''''''''''''
Function SetStartupUrl(url as String)
    SaveConfig("startupUrl", url)
End Function
'''''''''''''''''''''''''''
Function SetDisplayRotation(widget, rotation as Integer)
    SaveConfig("displayRotation", rotation)
    if rotation = 0 then
        widget.SetTransform("identity")
    else if rotation = 270 then
       widget.SetTransform("rot270")
    else if rotation = 90 then
        widget.SetTransform("rot90")
    end if
    return true
End Function
'''''''''''''''''''''''''''
Function GetDisplayRotation()
    config = LoadConfig()
    if config.displayRotation = invalid then
        return 0
    end if
    return config.displayRotation
End Function
'''''''''''''''''''''''''''
Function SetCursorVisible(visible)
    if visible="true" then
        visible = true
    else if visible="false" then
        visible = false
    end if
    
    if m.appspaceGlobal.vKeyboardProp.isVKeyboardShow = true 
        return false
    end if

    m.appspaceGlobal.touchScreen.EnableCursor(visible)
    SaveConfig("cursorVisible", visible)
End Function
'''''''''''''''''''''''''''
Function GetCursorVisible()
    config = LoadConfig()
    if config.cursorVisible = invalid then
        return false
    end if
    return config.cursorVisible
End Function
'''''''''''''''''''''''''''
Function ExecuteScript(script as String)
    res = eval(script)

    if type(res)="roList" then
        return false
    else if type(res)="Integer" then
        if res=&hFC or res=&hE2 then
            return true
        end if
    end if

    return false
End Function
'''''''''''''''''''''''''''
Function ExecuteFile(path as String)
    run(["autorun.brs", path])
    result=GetLastRunCompileError()
    if result = invalid then
        return true
    else
        return false
    end if
End Function
'''''''''''''''''''''''''''
Function GetDisplayResolutionX()
    return m.appspaceGlobal.width
End Function
'''''''''''''''''''''''''''
Function GetDisplayResolutionY()
    return m.appspaceGlobal.height
End Function
'''''''''''''''''''''''''''
Function GetMemoryUsage()
    aa = CreateObject("roAssociativeArray")
    aa.AddReplace("item", "meminfo")
    di = CreateObject("roDeviceInfo")
    return di.GetLoadStatistics(aa)
End Function
'''''''''''''''''''''''''''
Function GetCpuUsage()
    a2 = CreateObject("roAssociativeArray")
    a2.AddReplace("item", "loadavg")
    di2 = CreateObject("roDeviceInfo")
    return di2.GetLoadStatistics(a2)
End Function
'''''''''''''''''''''''''''
Function startServer(port)
    print "startServer!!!! : " + port
    PrintMessage("StartServer")
    m.appspaceGlobal.isWebSocketStart = true
End Function
'''''''''''''''''''''''''''
Function stopServer()
    print "stopServer!!!! : "
    PrintMessage("StopServer")
    m.appspaceGlobal.isWebSocketStart = false
End Function
'''''''''''''''''''''''''''
Function createVKeyboard(keyboardUrl)
    ' Create virtual keyboard
    rv = CreateObject("rorectangle", 0,0,1920,1080)
    m.appspaceGlobal.vKeyboard = CreateObject("rovirtualkeyboard", rv)
    m.appspaceGlobal.vKeyboard.setresource(keyboardUrl)
    m.appspaceGlobal.vKeyboard.setPort(m.appspaceGlobal.messagePort)
    m.appspaceGlobal.vKeyboardProp.isVKeyboardEnabled = true
    SetKeyboardDisplayRotation()
End Function
'''''''''''''''''''''''''''
Function SetKeyboardDisplayRotation()
    if m.appspaceGlobal.vKeyboard <> invalid then
        virtualKeyboardOrientation = GetDisplayRotation()
        SetDisplayRotation(m.appspaceGlobal.vKeyboard, virtualKeyboardOrientation)
    end if
End Function
'''''''''''''''''''''''''''
Function removeVKeyboard()
    ' Remove virtual keyboard
    m.appspaceGlobal.vKeyboard = invalid
    m.appspaceGlobal.vKeyboardProp = {isVKeyboardEnabled:false, isVKeyboardShow:false}
End Function
'''''''''''''''''''''''''''
Function setVolume(volume)
    'set the device volume for both output
    m.appspaceGlobal.audioAnalogOutput.SetVolume(volume)
    m.appspaceGlobal.audioHDMIOutput.SetVolume(volume)
End Function
'''''''''''''''''''''''''''
Function createInAppBrowser(url)
    m.appspaceGlobal.inAppBrowserMessagePort = CreateObject("roMessagePort")
    disposeInAppBrowser()
    m.appspaceGlobal.htmlWidget.hide()
    m.appspaceGlobal.inAppBrowserUrl = url
    m.appspaceGlobal.inAppBrowser = CreateHtmlWidget(url, m.appspaceGlobal.inAppBrowserMessagePort)
    SetInAppBrowserDisplayRotation()
    m.appspaceGlobal.inAppBrowser.Show()
    return m.appspaceGlobal.inAppBrowser
End Function
'''''''''''''''''''''''''''
Function SetInAppBrowserDisplayRotation()
    if m.appspaceGlobal.inAppBrowser <> invalid then
        inAppBrowserRotation = GetDisplayRotation()
        SetDisplayRotation(m.appspaceGlobal.inAppBrowser, inAppBrowserRotation)
    end if
End Function
'''''''''''''''''''''''''''
Function disposeInAppBrowser() As Void
    if type(m.appspaceGlobal.inAppBrowser) = "roHtmlWidget" then
       m.appspaceGlobal.inAppBrowser = 0
       m.appspaceGlobal.inAppBrowserUrl = ""
    end if

    m.appspaceGlobal.htmlWidget.show()
End Function
'''''''''''''''''''''''''''
Function clearWebCache() As Boolean   
    return m.appspaceGlobal.htmlWidget.FlushCachedResources()
End Function
'''''''''''''''''''''''''''
Function PrintMessage(message as String) As Void
    systemLog = CreateObject("roSystemLog")
    systemLog.sendline("  @@@Appspace|main.brs|" + message + " @@@")
End Function
'''''''''''''''''''''''''''