Library "plugins.brs"

Sub Main()
    pluginsDirectoryPath$ = "/plugins"
    pluginsDirectory = ListDirectory(pluginsDirectoryPath$)
    m.messagePort = CreateObject("roMessagePort")
    m.scriptPlugins = CreateObject("roArray", 1, true)
    ' initialize appspace plugin
    InitializePlugin("appspace", "")
    for each directoryName in pluginsDirectory
        InitializePlugin(directoryName, pluginsDirectoryPath$)
    end for

    while true
        event = m.messagePort.WaitMessage(10)
        for each scriptPlugin in m.scriptPlugins
            blockOtherPlugins = scriptPlugin.ProcessEvent(event)
            if blockOtherPlugins then
                exit for
            endif
        next
    end while
End Sub

Function InitializePlugin(pluginName as String, rootPath as String)
    ERR_NORMAL_END = &hFC
    pluginFile = rootPath + "/" + pluginName + "/main.brs"
    if IsFileExists(pluginFile) = false then
        return false
    end if
    
    initializeFunction$ = "result = " + pluginName + "_Initialize(m.messagePort, {}, m)"
    retVal = Eval(initializeFunction$)
    message = ""
    if type(retVal) = "roList" then
        LogMessage("Failure executing Eval to initialize script plugin file: error string was " + retVal[0].ERRSTR + ", line number was " + stri(retVal[0].LINENO) + ", call was " + initializeFunction$)
        return false
    end if

    if retVal <> ERR_NORMAL_END then
        LogMessage("Failure executing Eval to initialize script plugin file: return value = " + stri(retVal) + ", call was " + initializeFunction$)
        return false
    end if

    m.scriptPlugins.push(result)
    return true
End Function

Function ListDirectory(path as String)
    return ListDir(path)
End Function

Function IsFileExists(path as String)
    file = CreateObject("roReadFile", path)
    if type(file) = "roReadFile" then
        return true
    end if

    return false
End Function

Sub LogMessage(message as string)
    slog = createobject("roSystemLog")
    slog.sendline("APPSPACE|autorun.brs: " + message)
End Sub